export type ButtonVariant =
  | 'solid'
  | 'ghost'
  // | 'danger'
  | 'outline'
  | 'link'
  | 'action'
  | 'icon'
  // | 'icon-ghost'
  // | 'icon-danger'

export type ButtonSize = 'small' | 'large'

export type ButtonPadding = 'default' | 'tight'

export type ButtonState = 'default' | 'mellow' | 'danger'

export type ButtonVariantMap = {
  [K in ButtonVariant]: {
    base: string
    baseAs: string
    class: string
    sizes: {
      [K in ButtonSize]?: string
    }
    padding: {
      [K in ButtonPadding]?: {
        [K in ButtonSize]?: string
      }
    }
    states: {
      [K in ButtonState]?: {
        [K in ButtonSize]?: string
      }
    }
    loaderSize?: {
      [K in ButtonSize]: number
    }
    alignment?: {
      left?: string
      center?: string
      right?: string
    }
  }
}

export type ButtonPaddingMap = {
  [K in ButtonVariant]?: ButtonPadding[]
}

export type ButtonSizeMap = {
  [K in ButtonVariant]?: ButtonSize[]
}

export type IconName =
  | 'academic-cap'
  | 'adjustments-horizontal'
  | 'adjustments-vertical'
  | 'archive-box-arrow-down'
  | 'archive-box'
  | 'archive-box-xmark'
  | 'arrow-down-circle'
  | 'arrow-down'
  | 'arrow-down-left'
  | 'arrow-down-on-square'
  | 'arrow-down-on-square-stack'
  | 'arrow-down-right'
  | 'arrow-down-tray'
  | 'arrow-left-circle'
  | 'arrow-left'
  | 'arrow-left-on-rectangle'
  | 'arrow-long-down'
  | 'arrow-long-left'
  | 'arrow-long-right'
  | 'arrow-long-up'
  | 'arrow-path'
  | 'arrow-path-rounded-square'
  | 'arrow-right-circle'
  | 'arrow-right'
  | 'arrow-right-on-rectangle'
  | 'arrow-small-down'
  | 'arrow-small-left'
  | 'arrow-small-right'
  | 'arrow-small-up'
  | 'arrow-top-right-on-square'
  | 'arrow-trending-down'
  | 'arrow-trending-up'
  | 'arrow-up-circle'
  | 'arrow-up'
  | 'arrow-up-left'
  | 'arrow-up-on-square'
  | 'arrow-up-on-square-stack'
  | 'arrow-up-right'
  | 'arrow-up-tray'
  | 'arrow-uturn-down'
  | 'arrow-uturn-left'
  | 'arrow-uturn-right'
  | 'arrow-uturn-up'
  | 'arrows-pointing-in'
  | 'arrows-pointing-out'
  | 'arrows-right-left'
  | 'arrows-up-down'
  | 'at-symbol'
  | 'backspace'
  | 'backward'
  | 'banknotes'
  | 'bars2icon'
  | 'bars3bottom-left'
  | 'bars3bottom-right'
  | 'bars3center-left'
  | 'bars3icon'
  | 'bars4icon'
  | 'bars-arrow-down'
  | 'bars-arrow-up'
  | 'battery0icon'
  | 'battery100icon'
  | 'battery50icon'
  | 'beaker'
  | 'bell-alert'
  | 'bell'
  | 'bell-slash'
  | 'bell-snooze'
  | 'bolt'
  | 'bolt-slash'
  | 'book-open'
  | 'bookmark'
  | 'bookmark-slash'
  | 'bookmark-square'
  | 'briefcase'
  | 'bug-ant'
  | 'building-library'
  | 'building-office2icon'
  | 'building-office'
  | 'building-storefront'
  | 'cake'
  | 'calculator'
  | 'calendar-days'
  | 'calendar'
  | 'camera'
  | 'chart-bar'
  | 'chart-bar-square'
  | 'chart-pie'
  | 'chat-bubble-bottom-center'
  | 'chat-bubble-bottom-center-text'
  | 'chat-bubble-left-ellipsis'
  | 'chat-bubble-left'
  | 'chat-bubble-left-right'
  | 'chat-bubble-oval-left-ellipsis'
  | 'chat-bubble-oval-left'
  | 'check-badge'
  | 'check-circle'
  | 'check'
  | 'chevron-double-down'
  | 'chevron-double-left'
  | 'chevron-double-right'
  | 'chevron-double-up'
  | 'chevron-down'
  | 'chevron-left'
  | 'chevron-right'
  | 'chevron-up-down'
  | 'chevron-up'
  | 'circle-stack'
  | 'clipboard-document-check'
  | 'clipboard-document'
  | 'clipboard-document-list'
  | 'clipboard'
  | 'clock'
  | 'cloud-arrow-down'
  | 'cloud-arrow-up'
  | 'cloud'
  | 'code-bracket'
  | 'code-bracket-square'
  | 'cog6tooth'
  | 'cog8tooth'
  | 'cog'
  | 'command-line'
  | 'computer-desktop'
  | 'cpu-chip'
  | 'credit-card'
  | 'cube'
  | 'cube-transparent'
  | 'currency-bangladeshi'
  | 'currency-dollar'
  | 'currency-euro'
  | 'currency-pound'
  | 'currency-rupee'
  | 'currency-yen'
  | 'cursor-arrow-rays'
  | 'cursor-arrow-ripple'
  | 'device-phone-mobile'
  | 'device-tablet'
  | 'document-arrow-down'
  | 'document-arrow-up'
  | 'document-chart-bar'
  | 'document-check'
  | 'document-duplicate'
  | 'document'
  | 'document-magnifying-glass'
  | 'document-minus'
  | 'document-plus'
  | 'document-text'
  | 'ellipsis-horizontal-circle'
  | 'ellipsis-horizontal'
  | 'ellipsis-vertical'
  | 'envelope'
  | 'envelope-open'
  | 'exclamation-circle'
  | 'exclamation-triangle'
  | 'eye-dropper'
  | 'eye'
  | 'eye-slash'
  | 'face-frown'
  | 'face-smile'
  | 'film'
  | 'finger-print'
  | 'fire'
  | 'flag'
  | 'folder-arrow-down'
  | 'folder'
  | 'folder-minus'
  | 'folder-open'
  | 'folder-plus'
  | 'forward'
  | 'funnel'
  | 'gif'
  | 'gift'
  | 'gift-top'
  | 'globe-alt'
  | 'globe-americas'
  | 'globe-asia-australia'
  | 'globe-europe-africa'
  | 'hand-raised'
  | 'hand-thumb-down'
  | 'hand-thumb-up'
  | 'hashtag'
  | 'heart'
  | 'home'
  | 'home-modern'
  | 'identification'
  | 'inbox-arrow-down'
  | 'inbox'
  | 'inbox-stack'
  | 'information-circle'
  | 'key'
  | 'language'
  | 'lifebuoy'
  | 'light-bulb'
  | 'link'
  | 'list-bullet'
  | 'lock-closed'
  | 'lock-open'
  | 'magnifying-glass-circle'
  | 'magnifying-glass'
  | 'magnifying-glass-minus'
  | 'magnifying-glass-plus'
  | 'map'
  | 'map-pin'
  | 'megaphone'
  | 'microphone'
  | 'minus-circle'
  | 'minus'
  | 'minus-small'
  | 'moon'
  | 'musical-note'
  | 'newspaper'
  | 'no-symbol'
  | 'paint-brush'
  | 'paper-airplane'
  | 'paper-clip'
  | 'pause-circle'
  | 'pause'
  | 'pencil'
  | 'pencil-square'
  | 'phone-arrow-down-left'
  | 'phone-arrow-up-right'
  | 'phone'
  | 'phone-xmark'
  | 'photo'
  | 'play-circle'
  | 'play'
  | 'play-pause'
  | 'plus-circle'
  | 'plus'
  | 'plus-small'
  | 'power'
  | 'presentation-chart-bar'
  | 'presentation-chart-line'
  | 'printer'
  | 'puzzle-piece'
  | 'qr-code'
  | 'question-mark-circle'
  | 'queue-list'
  | 'radio'
  | 'receipt-percent'
  | 'receipt-refund'
  | 'rectangle-group'
  | 'rectangle-stack'
  | 'rocket-launch'
  | 'rss'
  | 'scale'
  | 'scissors'
  | 'server'
  | 'server-stack'
  | 'share'
  | 'shield-check'
  | 'shield-exclamation'
  | 'shopping-bag'
  | 'shopping-cart'
  | 'signal'
  | 'signal-slash'
  | 'sparkles'
  | 'speaker-wave'
  | 'speaker-xmark'
  | 'square2stack'
  | 'square3stack3dicon'
  | 'squares2x2icon'
  | 'squares-plus'
  | 'star'
  | 'stop-circle'
  | 'stop'
  | 'sun'
  | 'swatch'
  | 'table-cells'
  | 'tag'
  | 'ticket'
  | 'trash'
  | 'trophy'
  | 'truck'
  | 'tv'
  | 'user-circle'
  | 'user-group'
  | 'user'
  | 'user-minus'
  | 'user-plus'
  | 'users'
  | 'variable'
  | 'video-camera'
  | 'video-camera-slash'
  | 'view-columns'
  | 'viewfinder-circle'
  | 'wallet'
  | 'wifi'
  | 'window'
  | 'wrench'
  | 'wrench-screwdriver'
  | 'xcircle'
  | 'xmark'

export type IconType = 'solid' | 'outline' | 'mini' | 'micro'
